/*
 * Copyright (C) STMicroelectronics Ltd. 2002, 2003, 2007-2009
 *
 * andy.sturges@st.com
 * Sean McGoogan <Sean.McGoogan@st.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * This is derived from STMicroelectronics gnu toolchain example:
 *   sh-superh-elf/examples/bare/sh4reg/st40reg.h
 */

#ifndef __ST40REG_H
#define __ST40REG_H

#include "asm/sh4regtype.h"

/*----------------------------------------------------------------------------*/

/*
 * Set default endian to little
 */

#if defined(ST40_LITTLE_ENDIAN) && defined(ST40_BIG_ENDIAN)
#error ST40_LITTLE_ENDIAN and ST40_BIG_ENDIAN both defined
#endif

#if !defined(ST40_LITTLE_ENDIAN) && !defined(ST40_BIG_ENDIAN)
#define ST40_LITTLE_ENDIAN
#endif

/*----------------------------------------------------------------------------*/

#include "sh4reg.h"

/*----------------------------------------------------------------------------*/

/*
 * ST40 control registers
 */

/* Clock Pulse Generator control registers (all ST40 variants) */
#define ST40_CPG_FRQCR			SH4_WORD_REG(ST40_CPG_REGS_BASE + 0x00)
#define ST40_CPG_STBCR			SH4_BYTE_REG(ST40_CPG_REGS_BASE + 0x04)
#define ST40_CPG_WTCNT			SH4_WORD_REG(ST40_CPG_REGS_BASE + 0x08)
#define ST40_CPG_WTCNT_R		SH4_BYTE_REG(ST40_CPG_REGS_BASE + 0x08)
#define ST40_CPG_WTCSR			SH4_WORD_REG(ST40_CPG_REGS_BASE + 0x0c)
#define ST40_CPG_WTCSR_R		SH4_BYTE_REG(ST40_CPG_REGS_BASE + 0x0c)
#define ST40_CPG_STBCR2			SH4_BYTE_REG(ST40_CPG_REGS_BASE + 0x10)
#define ST40_CPG_WTCSR2			SH4_WORD_REG(ST40_CPG_REGS_BASE + 0x1c)
#define ST40_CPG_WTCSR2_R		SH4_BYTE_REG(ST40_CPG_REGS_BASE + 0x1c)
#define ST40_CPG_FRQCR2			SH4_WORD_REG(ST40_CPG_REGS_BASE + 0xc0)

/* Interrupt controller registers (all ST40 variants) */
#define ST40_INTC_ICR			SH4_WORD_REG(ST40_INTC_REGS_BASE + 0x00)
#define ST40_INTC_IPRA			SH4_WORD_REG(ST40_INTC_REGS_BASE + 0x04)
#define ST40_INTC_IPRB			SH4_WORD_REG(ST40_INTC_REGS_BASE + 0x08)
#define ST40_INTC_IPRC			SH4_WORD_REG(ST40_INTC_REGS_BASE + 0x0c)
#define ST40_INTC_IPRD			SH4_WORD_REG(ST40_INTC_REGS_BASE + 0x10)

/* Interrupt Controller control registers (all ST40 variants) */
#define ST40_INTC2_INTPRI00		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x00)
#define ST40_INTC2_INTPRI04		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x04)
#define ST40_INTC2_INTPRI08		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x08)
#define ST40_INTC2_INTREQ00		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x20)
#define ST40_INTC2_INTREQ04		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x24)
#define ST40_INTC2_INTREQ08		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x28)
#define ST40_INTC2_INTMSK00		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x40)
#define ST40_INTC2_INTMSK04		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x44)
#define ST40_INTC2_INTMSK08		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x48)
#define ST40_INTC2_INTMSKCLR00		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x60)
#define ST40_INTC2_INTMSKCLR04		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x64)
#define ST40_INTC2_INTMSKCLR08		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x68)
#define ST40_INTC2_INTC2MODE		SH4_DWORD_REG(ST40_INTC2_REGS_BASE + 0x80)

/* Interrupt Level Controller control registers (all ST40 variants) */
#define ST40_ILC_INPUT_INTERRUPT(n)	SH4_DWORD_REG(ST40_ILC_REGS_BASE + (0x0080 + ((n) * 4)))
#define ST40_ILC_STATUS(n)		SH4_DWORD_REG(ST40_ILC_REGS_BASE + (0x0200 + ((n) * 4)))
#define ST40_ILC_CLEAR_STATUS(n)	SH4_DWORD_REG(ST40_ILC_REGS_BASE + (0x0280 + ((n) * 4)))
#define ST40_ILC_ENABLE(n)		SH4_DWORD_REG(ST40_ILC_REGS_BASE + (0x0400 + ((n) * 4)))
#define ST40_ILC_CLEAR_ENABLE(n)	SH4_DWORD_REG(ST40_ILC_REGS_BASE + (0x0480 + ((n) * 4)))
#define ST40_ILC_SET_ENABLE(n)		SH4_DWORD_REG(ST40_ILC_REGS_BASE + (0x0500 + ((n) * 4)))
#define ST40_ILC_WAKEUP_ENABLE(n)	SH4_DWORD_REG(ST40_ILC_REGS_BASE + (0x0600 + ((n) * 4)))
#define ST40_ILC_WAKEUP_ACTIVE_LEVEL(n)	SH4_DWORD_REG(ST40_ILC_REGS_BASE + (0x0680 + ((n) * 4)))

/* Serial Communication Interfaces control registers (all ST40 variants) */
#define ST40_SCIF_SCSMR(n)		SH4_WORD_REG(ST40_SCIF##n##_REGS_BASE + 0x00)
#define ST40_SCIF_SCBRR(n)		SH4_BYTE_REG(ST40_SCIF##n##_REGS_BASE + 0x04)
#define ST40_SCIF_SCSCR(n)		SH4_WORD_REG(ST40_SCIF##n##_REGS_BASE + 0x08)
#define ST40_SCIF_SCFTDR(n)		SH4_BYTE_REG(ST40_SCIF##n##_REGS_BASE + 0x0c)
#define ST40_SCIF_SCFSR(n)		SH4_WORD_REG(ST40_SCIF##n##_REGS_BASE + 0x10)
#define ST40_SCIF_SCFRDR(n)		SH4_BYTE_REG(ST40_SCIF##n##_REGS_BASE + 0x14)
#define ST40_SCIF_SCFCR(n)		SH4_WORD_REG(ST40_SCIF##n##_REGS_BASE + 0x18)
#define ST40_SCIF_SCFDR(n)		SH4_WORD_REG(ST40_SCIF##n##_REGS_BASE + 0x1c)
#define ST40_SCIF_SCSPTR(n)		SH4_WORD_REG(ST40_SCIF##n##_REGS_BASE + 0x20)
#define ST40_SCIF_SCLSR(n)		SH4_WORD_REG(ST40_SCIF##n##_REGS_BASE + 0x24)

/* Clock Generator control registers (all ST40 variants) */
#define ST40_CLOCKGEN_PLL1CR1(n)	SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x00)
#define ST40_CLOCKGEN_PLL1CR2(n)	SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x08)
#define ST40_CLOCKGEN_PLL2CR(n)		SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x10)
#define ST40_CLOCKGEN_STBREQCR(n)	SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x18)
#define ST40_CLOCKGEN_STBREQCR_SET(n)	SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x20)
#define ST40_CLOCKGEN_STBREQCR_CLR(n)	SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x28)
#define ST40_CLOCKGEN_STBACKCR(n)	SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x30)
#define ST40_CLOCKGEN_CLK4CR(n)		SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x38)
#define ST40_CLOCKGEN_CPG_BYPASS(n)	SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x40)
#define ST40_CLOCKGEN_PLL2_MUXCR(n)	SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x48)
#define ST40_CLOCKGEN_CLK1CR(n)		SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x50)
#define ST40_CLOCKGEN_CLK2CR(n)		SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x58)
#define ST40_CLOCKGEN_CLK3CR(n)		SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x60)
#define ST40_CLOCKGEN_CLK_SELCR(n)	SH4_DWORD_REG(ST40_CLOCKGEN##n##_REGS_BASE + 0x68)

#define ST40_CLOCKGEN_CLK_RATIO(n) ST40_CLOCKGEN_PLL2_MUXCR(n)
#define ST40_CLOCKGEN_CLKDDRCR(n) ST40_CLOCKGEN_CLK_SELCR(n)

/* Direct Memeory Access Controller control registers (all ST40 variants) */
#define ST40_DMAC_CHAN0_IDENTITY	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x00)
#define ST40_DMAC_CHAN0_ENABLE		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x08)
#define ST40_DMAC_CHAN0_DISABLE		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x10)
#define ST40_DMAC_CHAN0_STATUS		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x18)
#define ST40_DMAC_CHAN0_ACTION		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x20)
#define ST40_DMAC_CHAN0_POINTER		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x28)
#define ST40_DMAC_CHAN0_SUBBASE		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x30)
#define ST40_DMAC_CHAN0_SUBENABLE	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x38)
#define ST40_DMAC_CHAN0_SUBDISABLE	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x40)
#define ST40_DMAC_CHAN0_SUBINT_ENB	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x48)
#define ST40_DMAC_CHAN0_SUBINT_DIS	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x50)
#define ST40_DMAC_CHAN0_SUBINT_STAT	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x58)
#define ST40_DMAC_CHAN0_SUNINT_ACT	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x60)
#define ST40_DMAC_CHAN0_CONTROL		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x80)
#define ST40_DMAC_CHAN0_COUNT		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x88)
#define ST40_DMAC_CHAN0_SAR		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x90)
#define ST40_DMAC_CHAN0_DAR		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + 0x100) + 0x98)

#define ST40_DMAC_CHANX_IDENTITY(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x00)
#define ST40_DMAC_CHANX_ENABLE(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x08)
#define ST40_DMAC_CHANX_DISABLE(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x10)
#define ST40_DMAC_CHANX_STATUS(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x18)
#define ST40_DMAC_CHANX_ACTION(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x20)
#define ST40_DMAC_CHANX_POINTER(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x28)
#define ST40_DMAC_CHANX_REQUEST(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x30)
#define ST40_DMAC_CHANX_CONTROL(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x80)
#define ST40_DMAC_CHANX_COUNT(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x88)
#define ST40_DMAC_CHANX_SAR(n)		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x90)
#define ST40_DMAC_CHANX_DAR(n)		SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0x98)
#define ST40_DMAC_CHANX_NEXT_PTR(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0xa0)
#define ST40_DMAC_CHANX_SRC_LENGTH(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0xa8)
#define ST40_DMAC_CHANX_SRC_STRIDE(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0xb0)
#define ST40_DMAC_CHANX_DST_LENGTH(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0xb8)
#define ST40_DMAC_CHANX_DST_STRIDE(n)	SH4_DWORD_REG((ST40_DMAC_REGS_BASE + (n)) + 0xc0)

#define ST40_DMAC_CHAN1_IDENTITY	ST40_DMAC_CHANX_IDENTITY(0x200)
#define ST40_DMAC_CHAN1_ENABLE		ST40_DMAC_CHANX_ENABLE(0x200)
#define ST40_DMAC_CHAN1_DISABLE		ST40_DMAC_CHANX_DISABLE(0x200)
#define ST40_DMAC_CHAN1_STATUS		ST40_DMAC_CHANX_STATUS(0x200)
#define ST40_DMAC_CHAN1_ACTION		ST40_DMAC_CHANX_ACTION(0x200)
#define ST40_DMAC_CHAN1_POINTER		ST40_DMAC_CHANX_POINTER(0x200)
#define ST40_DMAC_CHAN1_REQUEST		ST40_DMAC_CHANX_REQUEST(0x200)
#define ST40_DMAC_CHAN1_CONTROL		ST40_DMAC_CHANX_CONTROL(0x200)
#define ST40_DMAC_CHAN1_COUNT		ST40_DMAC_CHANX_COUNT(0x200)
#define ST40_DMAC_CHAN1_SAR		ST40_DMAC_CHANX_SAR(0x200)
#define ST40_DMAC_CHAN1_DAR		ST40_DMAC_CHANX_DAR(0x200)
#define ST40_DMAC_CHAN1_NEXT_PTR	ST40_DMAC_CHANX_NEXT_PTR(0x200)
#define ST40_DMAC_CHAN1_SRC_LENGTH	ST40_DMAC_CHANX_SRC_LENGTH(0x200)
#define ST40_DMAC_CHAN1_SRC_STRIDE	ST40_DMAC_CHANX_SRC_STRIDE(0x200)
#define ST40_DMAC_CHAN1_DST_LENGTH	ST40_DMAC_CHANX_DST_LENGTH(0x200)
#define ST40_DMAC_CHAN1_DST_STRIDE	ST40_DMAC_CHANX_DST_STRIDE(0x200)

#define ST40_DMAC_CHAN2_IDENTITY	ST40_DMAC_CHANX_IDENTITY(0x300)
#define ST40_DMAC_CHAN2_ENABLE		ST40_DMAC_CHANX_ENABLE(0x300)
#define ST40_DMAC_CHAN2_DISABLE		ST40_DMAC_CHANX_DISABLE(0x300)
#define ST40_DMAC_CHAN2_STATUS		ST40_DMAC_CHANX_STATUS(0x300)
#define ST40_DMAC_CHAN2_ACTION		ST40_DMAC_CHANX_ACTION(0x300)
#define ST40_DMAC_CHAN2_POINTER		ST40_DMAC_CHANX_POINTER(0x300)
#define ST40_DMAC_CHAN2_REQUEST		ST40_DMAC_CHANX_REQUEST(0x300)
#define ST40_DMAC_CHAN2_CONTROL		ST40_DMAC_CHANX_CONTROL(0x300)
#define ST40_DMAC_CHAN2_COUNT		ST40_DMAC_CHANX_COUNT(0x300)
#define ST40_DMAC_CHAN2_SAR		ST40_DMAC_CHANX_SAR(0x300)
#define ST40_DMAC_CHAN2_DAR		ST40_DMAC_CHANX_DAR(0x300)
#define ST40_DMAC_CHAN2_NEXT_PTR	ST40_DMAC_CHANX_NEXT_PTR(0x300)
#define ST40_DMAC_CHAN2_SRC_LENGTH	ST40_DMAC_CHANX_SRC_LENGTH(0x300)
#define ST40_DMAC_CHAN2_SRC_STRIDE	ST40_DMAC_CHANX_SRC_STRIDE(0x300)
#define ST40_DMAC_CHAN2_DST_LENGTH	ST40_DMAC_CHANX_DST_LENGTH(0x300)
#define ST40_DMAC_CHAN2_DST_STRIDE	ST40_DMAC_CHANX_DST_STRIDE(0x300)

#define ST40_DMAC_CHAN3_IDENTITY	ST40_DMAC_CHANX_IDENTITY(0x400)
#define ST40_DMAC_CHAN3_ENABLE		ST40_DMAC_CHANX_ENABLE(0x400)
#define ST40_DMAC_CHAN3_DISABLE		ST40_DMAC_CHANX_DISABLE(0x400)
#define ST40_DMAC_CHAN3_STATUS		ST40_DMAC_CHANX_STATUS(0x400)
#define ST40_DMAC_CHAN3_ACTION		ST40_DMAC_CHANX_ACTION(0x400)
#define ST40_DMAC_CHAN3_POINTER		ST40_DMAC_CHANX_POINTER(0x400)
#define ST40_DMAC_CHAN3_REQUEST		ST40_DMAC_CHANX_REQUEST(0x400)
#define ST40_DMAC_CHAN3_CONTROL		ST40_DMAC_CHANX_CONTROL(0x400)
#define ST40_DMAC_CHAN3_COUNT		ST40_DMAC_CHANX_COUNT(0x400)
#define ST40_DMAC_CHAN3_SAR		ST40_DMAC_CHANX_SAR(0x400)
#define ST40_DMAC_CHAN3_DAR		ST40_DMAC_CHANX_DAR(0x400)
#define ST40_DMAC_CHAN3_NEXT_PTR	ST40_DMAC_CHANX_NEXT_PTR(0x400)
#define ST40_DMAC_CHAN3_SRC_LENGTH	ST40_DMAC_CHANX_SRC_LENGTH(0x400)
#define ST40_DMAC_CHAN3_SRC_STRIDE	ST40_DMAC_CHANX_SRC_STRIDE(0x400)
#define ST40_DMAC_CHAN3_DST_LENGTH	ST40_DMAC_CHANX_DST_LENGTH(0x400)
#define ST40_DMAC_CHAN3_DST_STRIDE	ST40_DMAC_CHANX_DST_STRIDE(0x400)

#define ST40_DMAC_CHAN4_IDENTITY	ST40_DMAC_CHANX_IDENTITY(0x500)
#define ST40_DMAC_CHAN4_ENABLE		ST40_DMAC_CHANX_ENABLE(0x500)
#define ST40_DMAC_CHAN4_DISABLE		ST40_DMAC_CHANX_DISABLE(0x500)
#define ST40_DMAC_CHAN4_STATUS		ST40_DMAC_CHANX_STATUS(0x500)
#define ST40_DMAC_CHAN4_ACTION		ST40_DMAC_CHANX_ACTION(0x500)
#define ST40_DMAC_CHAN4_POINTER		ST40_DMAC_CHANX_POINTER(0x500)
#define ST40_DMAC_CHAN4_REQUEST		ST40_DMAC_CHANX_REQUEST(0x500)
#define ST40_DMAC_CHAN4_CONTROL		ST40_DMAC_CHANX_CONTROL(0x500)
#define ST40_DMAC_CHAN4_COUNT		ST40_DMAC_CHANX_COUNT(0x500)
#define ST40_DMAC_CHAN4_SAR		ST40_DMAC_CHANX_SAR(0x500)
#define ST40_DMAC_CHAN4_DAR		ST40_DMAC_CHANX_DAR(0x500)
#define ST40_DMAC_CHAN4_NEXT_PTR	ST40_DMAC_CHANX_NEXT_PTR(0x500)
#define ST40_DMAC_CHAN4_SRC_LENGTH	ST40_DMAC_CHANX_SRC_LENGTH(0x500)
#define ST40_DMAC_CHAN4_SRC_STRIDE	ST40_DMAC_CHANX_SRC_STRIDE(0x500)
#define ST40_DMAC_CHAN4_DST_LENGTH	ST40_DMAC_CHANX_DST_LENGTH(0x500)
#define ST40_DMAC_CHAN4_DST_STRIDE	ST40_DMAC_CHANX_DST_STRIDE(0x500)

#define ST40_DMAC_VCR_STATUS		SH4_DWORD_REG(ST40_DMAC_REGS_BASE + 0x00)
#define ST40_DMAC_VCR_VERSION		SH4_DWORD_REG(ST40_DMAC_REGS_BASE + 0x08)
#define ST40_DMAC_ENABLE		SH4_DWORD_REG(ST40_DMAC_REGS_BASE + 0x10)
#define ST40_DMAC_DISABLE		SH4_DWORD_REG(ST40_DMAC_REGS_BASE + 0x18)
#define ST40_DMAC_STATUS		SH4_DWORD_REG(ST40_DMAC_REGS_BASE + 0x20)
#define ST40_DMAC_INTERRUPT		SH4_DWORD_REG(ST40_DMAC_REGS_BASE + 0x28)
#define ST40_DMAC_ERROR			SH4_DWORD_REG(ST40_DMAC_REGS_BASE + 0x30)
#define ST40_DMAC_DEFINED		SH4_DWORD_REG(ST40_DMAC_REGS_BASE + 0x38)
#define ST40_DMAC_HANDSHAKE		SH4_DWORD_REG(ST40_DMAC_REGS_BASE + 0x40)

/* Parallel I/O control registers (all ST40 variants) */
#define ST40_PIO_POUT(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x00)
#define ST40_PIO_PIN(n)		SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x10)
#define ST40_PIO_PC0(n)		SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x20)
#define ST40_PIO_PC1(n)		SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x30)
#define ST40_PIO_PC2(n)		SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x40)
#define ST40_PIO_PCOMP(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x50)
#define ST40_PIO_PMASK(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x60)

/* PIO pseudo registers */
#define ST40_PIO_SET_POUT(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x04)
#define ST40_PIO_CLEAR_POUT(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x08)
#define ST40_PIO_SET_PC0(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x24)
#define ST40_PIO_CLEAR_PC0(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x28)
#define ST40_PIO_SET_PC1(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x34)
#define ST40_PIO_CLEAR_PC1(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x38)
#define ST40_PIO_SET_PC2(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x44)
#define ST40_PIO_CLEAR_PC2(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x48)
#define ST40_PIO_SET_PCOMP(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x54)
#define ST40_PIO_CLEAR_PCOMP(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x58)
#define ST40_PIO_SET_PMASK(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x64)
#define ST40_PIO_CLEAR_PMASK(n)	SH4_DWORD_REG(ST40_PIO##n##_REGS_BASE + 0x68)

/* Local Memory Interface control registers (all ST40 variants).
   Define ST40_LMI_VERSION for standard LMIs and ST40_LMIGP_VERSION for GP LMIs.
 */
#if !(defined(ST40_LMI_VERSION) || defined(ST40_LMIGP_VERSION))
/* For variants which do not define which LMI they have we define
   ST40_LMI_VERSION 2 as the default.
 */
#define ST40_LMI_VERSION 2
#endif
#if defined(ST40_LMI_VERSION)
#define ST40_LMI_VCR_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000000)
#define ST40_LMI_VCR_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000004)
#define ST40_LMI_VCR(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000000)
#define ST40_LMI_MIM_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000008)
#define ST40_LMI_MIM_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x00000c)
#define ST40_LMI_MIM(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000008)
#define ST40_LMI_SCR_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000010)
#define ST40_LMI_SCR_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000014)
#define ST40_LMI_SCR(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000010)
#define ST40_LMI_STR_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000018)
#define ST40_LMI_STR_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x00001c)
#define ST40_LMI_STR(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000018)
#define ST40_LMI_PBS_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000020)
#define ST40_LMI_PBS_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000024)
#define ST40_LMI_PBS(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000020)
#define ST40_LMI_COC_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000028)
#define ST40_LMI_COC_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x00002c)
#define ST40_LMI_COC(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000028)
#define ST40_LMI_SDRA0_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000030)
#define ST40_LMI_SDRA0_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000034)
#define ST40_LMI_SDRA0(n)	SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000030)
#define ST40_LMI_SDRA1_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000038)
#define ST40_LMI_SDRA1_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x00003c)
#define ST40_LMI_SDRA1(n)	SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000038)
#define ST40_LMI_CIC_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000040)
#define ST40_LMI_CIC_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000044)
#define ST40_LMI_CIC(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000040)
#if (ST40_LMI_VERSION > 2)
#define ST40_LMI_SDMR0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000048)
#define ST40_LMI_SDMR1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000050)
#else
#define ST40_LMI_SDMR0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x800000)
#define ST40_LMI_SDMR1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x900000)
#endif
#elif defined(ST40_LMIGP_VERSION)
#define ST40_LMI_VCR_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000000)
#define ST40_LMI_VCR_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000004)
#define ST40_LMI_VCR(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000000)
#define ST40_LMI_MIM_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000008)
#define ST40_LMI_MIM_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x00000c)
#define ST40_LMI_MIM(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000008)
#define ST40_LMI_SCR_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000010)
#define ST40_LMI_SCR_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000014)
#define ST40_LMI_SCR(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000010)
#define ST40_LMI_STR_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000018)
#define ST40_LMI_STR_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x00001c)
#define ST40_LMI_STR(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000018)
#define ST40_LMI_GCC_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000028)
#define ST40_LMI_GCC_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x00002c)
#define ST40_LMI_GCC(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000028)
#define ST40_LMI_SDRA0_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000030)
#define ST40_LMI_SDRA0_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000034)
#define ST40_LMI_SDRA0(n)	SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000030)
#define ST40_LMI_SDRA1_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000038)
#define ST40_LMI_SDRA1_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x00003c)
#define ST40_LMI_SDRA1(n)	SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000038)
#define ST40_LMI_CCO_0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000040)
#define ST40_LMI_CCO_1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000044)
#define ST40_LMI_CCO(n)		SH4_GWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000040)
#define ST40_LMI_SDMR0(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000048)
#define ST40_LMI_SDMR1(n)	SH4_DWORD_REG(ST40_LMI##n##_REGS_BASE + 0x000050)
#endif

/* Enhanced Flash Memory Interface control registers (all ST40 variants) */
#define ST40_EMI_VCR_0			SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0000)
#define ST40_EMI_VCR_1			SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0004)
#define ST40_EMI_VCR			SH4_GWORD_REG(ST40_EMI_REGS_BASE + 0x0000)
#define ST40_EMI_STATUSCFG		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0010)
#define ST40_EMI_STATUSLOCK		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0018)
#define ST40_EMI_LOCK			SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0020)
#define ST40_EMI_GENCFG			SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0028)
#define ST40_EMI_SDRAMNOPGEN		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0030)
#define ST40_EMI_SDRAMMODEREG		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0038)
#define ST40_EMI_SDRAMINIT		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0040)
#define ST40_EMI_REFRESHINIT		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0048)
#define ST40_EMI_FLASHCLKSEL		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0050)
#define ST40_EMI_SDRAMCLKSEL		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0058)
#define ST40_EMI_MPXCLKSEL		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0060)
#define ST40_EMI_CLKENABLE		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0068)
#define ST40_EMI_BANK0_EMICONFIGDATA0	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0100)
#define ST40_EMI_BANK0_EMICONFIGDATA1	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0108)
#define ST40_EMI_BANK0_EMICONFIGDATA2	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0110)
#define ST40_EMI_BANK0_EMICONFIGDATA3	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0118)
#define ST40_EMI_BANK1_EMICONFIGDATA0	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0140)
#define ST40_EMI_BANK1_EMICONFIGDATA1	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0148)
#define ST40_EMI_BANK1_EMICONFIGDATA2	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0150)
#define ST40_EMI_BANK1_EMICONFIGDATA3	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0158)
#define ST40_EMI_BANK2_EMICONFIGDATA0	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0180)
#define ST40_EMI_BANK2_EMICONFIGDATA1	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0188)
#define ST40_EMI_BANK2_EMICONFIGDATA2	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0190)
#define ST40_EMI_BANK2_EMICONFIGDATA3	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0198)
#define ST40_EMI_BANK3_EMICONFIGDATA0	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x01c0)
#define ST40_EMI_BANK3_EMICONFIGDATA1	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x01c8)
#define ST40_EMI_BANK3_EMICONFIGDATA2	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x01d0)
#define ST40_EMI_BANK3_EMICONFIGDATA3	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x01d8)
#define ST40_EMI_BANK4_EMICONFIGDATA0	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0200)
#define ST40_EMI_BANK4_EMICONFIGDATA1	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0208)
#define ST40_EMI_BANK4_EMICONFIGDATA2	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0210)
#define ST40_EMI_BANK4_EMICONFIGDATA3	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0218)
#define ST40_EMI_BANK5_EMICONFIGDATA0	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0240)
#define ST40_EMI_BANK5_EMICONFIGDATA1	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0248)
#define ST40_EMI_BANK5_EMICONFIGDATA2	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0250)
#define ST40_EMI_BANK5_EMICONFIGDATA3	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0258)

#define ST40_EMI_BASEADDRESS(bank)	SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0800 + (bank)*0x0010)
#define ST40_EMI_BANK0_BASEADDRESS	ST40_EMI_BASEADDRESS(0)
#define ST40_EMI_BANK1_BASEADDRESS	ST40_EMI_BASEADDRESS(1)
#define ST40_EMI_BANK2_BASEADDRESS	ST40_EMI_BASEADDRESS(2)
#define ST40_EMI_BANK3_BASEADDRESS	ST40_EMI_BASEADDRESS(3)
#define ST40_EMI_BANK4_BASEADDRESS	ST40_EMI_BASEADDRESS(4)
#define ST40_EMI_BANK5_BASEADDRESS	ST40_EMI_BASEADDRESS(5)
#define ST40_EMI_BANK_ENABLE		SH4_DWORD_REG(ST40_EMI_REGS_BASE + 0x0860)

/* EMI NAND flash registers */
#define ST40_EMI_NAND_REGS_BASE			(ST40_EMI_REGS_BASE + 0x1000)
#define ST40_EMI_NAND_BOOTBANK_CFG		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0000)
#define ST40_EMI_NAND_RBN_STA			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0004)
#define ST40_EMI_NAND_INT_EN			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0010)
#define ST40_EMI_NAND_INT_STA			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0014)
#define ST40_EMI_NAND_INT_CLR			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0018)
#define ST40_EMI_NAND_INT_EDGE_CFG		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x001c)
#define ST40_EMI_NAND_CTL_TIMING		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0040)
#define ST40_EMI_NAND_WEN_TIMING		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0044)
#define ST40_EMI_NAND_REN_TIMING		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0048)
#define ST40_EMI_NAND_BLOCK_ZERO_REMAP_REG	SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x004C)
#define ST40_EMI_NAND_FLEXMODE_CFG		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0100)
#define ST40_EMI_NAND_FLEX_MUXCTRL		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0104)
#define ST40_EMI_NAND_FLEX_CS_ALT		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0108)
#define ST40_EMI_NAND_FLEX_DATAWRT_CFG		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x010c)
#define ST40_EMI_NAND_FLEX_DATA_RD_CFG		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0110)
#define ST40_EMI_NAND_FLEX_CMD			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0114)
#define ST40_EMI_NAND_FLEX_ADD_REG		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0118)
#define ST40_EMI_NAND_FLEX_DATA			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0120)
#define ST40_EMI_NAND_VERSION_REG		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0144)
#define ST40_EMI_NAND_ADDRESS_REG_1		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x01E0)
#define ST40_EMI_NAND_ADDRESS_REG_2		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x01E4)
#define ST40_EMI_NAND_ADDRESS_REG_3		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x01E8)
#define ST40_EMI_NAND_MULTI_CS_CONFIG_REG	SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x01EC)
#define ST40_EMI_NAND_SEQ_REG1			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0200)
#define ST40_EMI_NAND_SEQ_REG2			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0204)
#define ST40_EMI_NAND_SEQ_REG3			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0208)
#define ST40_EMI_NAND_SEQ_REG4			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x020c)
#define ST40_EMI_NAND_ADD			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0210)
#define ST40_EMI_NAND_EXTRA_REG			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0214)
#define ST40_EMI_NAND_CMD			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0218)
#define ST40_EMI_NAND_SEQ_CFG			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x021c)
#define ST40_EMI_NAND_GEN_CFG			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0220)
#define ST40_EMI_NAND_SEQ_STA			SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0240)
#define ST40_EMI_NAND_ECC_CHECKCODE_0		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0280)
#define ST40_EMI_NAND_ECC_CHECKCODE_1		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0284)
#define ST40_EMI_NAND_ECC_CHECKCODE_2		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0288)
#define ST40_EMI_NAND_ECC_CHECKCODE_3		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x028c)
#define ST40_EMI_NAND_ECC_CHECKCODE_2X8_0	SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0290)
#define ST40_EMI_NAND_ECC_CHECKCODE_2X8_1	SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0294)
#define ST40_EMI_NAND_ECC_CHECKCODE_2X8_2	SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0298)
#define ST40_EMI_NAND_ECC_CHECKCODE_2X8_3	SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x029C)
#define ST40_EMI_NAND_DATA_FIFO_REG		SH4_DWORD_REG(ST40_EMI_NAND_REGS_BASE + 0x0300)

/* EMI SPI serial flash registers */
#define ST40_EMI_SPI_REGS_BASE			(ST40_EMI_REGS_BASE + 0x2000)
#define ST40_EMI_SPI_CLOCKDIV			SH4_DWORD_REG(ST40_EMI_SPI_REGS_BASE + 0x0010)
#define ST40_EMI_SPI_MODESELECT			SH4_DWORD_REG(ST40_EMI_SPI_REGS_BASE + 0x0018)
#define ST40_EMI_SPI_CONFIGDATA			SH4_DWORD_REG(ST40_EMI_SPI_REGS_BASE + 0x0020)
#define ST40_EMI_SPI_STATUSMODECHANGE		SH4_DWORD_REG(ST40_EMI_SPI_REGS_BASE + 0x0028)

/* Peripheral Component Interconnect control registers (all ST40 variants) */
/* PCI Local Registers */
#define ST40_PCI_VCR_STATUS	SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000000)
#define ST40_PCI_VCR_VERSION	SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000008)
#define ST40_PCI_CR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000010)
#define ST40_PCI_LSR0		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000014)
#define ST40_PCI_LAR0		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x00001c)
#define ST40_PCI_INT		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000024)
#define ST40_PCI_INTM		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000028)
#define ST40_PCI_AIR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x00002c)
#define ST40_PCI_CIR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000030)
#define ST40_PCI_AINT		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000040)
#define ST40_PCI_AINTM		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000044)
#define ST40_PCI_BMIR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000048)
#define ST40_PCI_PAR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x00004c)
#define ST40_PCI_MBR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000050)
#define ST40_PCI_IOBR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000054)
#define ST40_PCI_PINT		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000058)
#define ST40_PCI_PINTM		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x00005c)
#define ST40_PCI_MBMR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000070)
#define ST40_PCI_IOBMR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000074)

/* PCI Local Configuration Registers */
#define ST40_PCI_WCBAR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x00007c)
#define ST40_PCI_LOCCFG_UNLOCK	SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000034)
#define ST40_PCI_RBARR0		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000100)
#define ST40_PCI_RSR0		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000104)
#define ST40_PCI_RLAR0		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000108)
#define ST40_PCI_RBARR1		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000110)
#define ST40_PCI_RSR1		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000114)
#define ST40_PCI_RLAR1		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000118)
#define ST40_PCI_RBARR2		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000120)
#define ST40_PCI_RSR2		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000124)
#define ST40_PCI_RLAR2		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000128)
#define ST40_PCI_RBARR3		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000130)
#define ST40_PCI_RSR3		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000134)
#define ST40_PCI_RLAR3		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000138)
#define ST40_PCI_RBARR4		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000140)
#define ST40_PCI_RSR4		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000144)
#define ST40_PCI_RLAR4		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000148)
#define ST40_PCI_RBARR5		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000150)
#define ST40_PCI_RSR5		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000154)
#define ST40_PCI_RLAR5		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000158)
#define ST40_PCI_RBARR6		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000160)
#define ST40_PCI_RSR6		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000164)
#define ST40_PCI_RLAR6		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000168)
#define ST40_PCI_RBARR7		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000170)
#define ST40_PCI_RSR7		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000174)
#define ST40_PCI_RLAR7		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x000178)

/* PCI Configuration Space Registers (CSR) */
#define ST40_PCI_VID		SH4_WORD_REG(ST40_PCI_REGS_BASE + 0x010000)
#define ST40_PCI_DID		SH4_WORD_REG(ST40_PCI_REGS_BASE + 0x010002)
#define ST40_PCI_CMD		SH4_WORD_REG(ST40_PCI_REGS_BASE + 0x010004)
#define ST40_PCI_STATUS		SH4_WORD_REG(ST40_PCI_REGS_BASE + 0x010006)
#define ST40_PCI_RID_CLASS	SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x010008)
#define ST40_PCI_CLS		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x01000c)
#define ST40_PCI_MLT		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x01000d)
#define ST40_PCI_HDR		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x01000e)
#define ST40_PCI_BIST		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x01000f)
#define ST40_PCI_MBAR0		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x010010)
#define ST40_PCI_IBAR		SH4_DWORD_REG(ST40_PCI_REGS_BASE + 0x010018)
#define ST40_PCI_SVID		SH4_WORD_REG(ST40_PCI_REGS_BASE + 0x01002c)
#define ST40_PCI_SID		SH4_WORD_REG(ST40_PCI_REGS_BASE + 0x01002e)
#define ST40_PCI_CP		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x010034)
#define ST40_PCI_INTLINE	SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x01003c)
#define ST40_PCI_INTPIN		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x01003d)
#define ST40_PCI_MINGNT		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x01003e)
#define ST40_PCI_MAXLAT		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x01003f)
#define ST40_PCI_TRDYTIME	SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x010040)
#define ST40_PCI_RETRYTIME	SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x010041)
#define ST40_PCI_CID		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x0100dc)
#define ST40_PCI_NIP		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x0100dd)
#define ST40_PCI_PMC		SH4_WORD_REG(ST40_PCI_REGS_BASE + 0x0100de)
#define ST40_PCI_PMCSR		SH4_WORD_REG(ST40_PCI_REGS_BASE + 0x0100e0)
#define ST40_PCI_PMCSR_BSE	SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x0100e2)
#define ST40_PCI_PCDD		SH4_BYTE_REG(ST40_PCI_REGS_BASE + 0x0100e3)

/* External MicroProcessor Interface control registers (all ST40 variants) */
#define ST40_EMPI_VCR_STATUS	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0000)
#define ST40_EMPI_VCR_VERSION	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0008)
#define ST40_EMPI_SYSTEM	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0010)
#define ST40_EMPI_ISTATUS	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0018)
#define ST40_EMPI_IMASK		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0020)
#define ST40_EMPI_MPXCFG	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0028)
#define ST40_EMPI_DMAINV	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0030)
#define ST40_EMPI_DMACFG0	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0080)
#define ST40_EMPI_DMACFG1	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0088)
#define ST40_EMPI_DMACFG2	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0090)
#define ST40_EMPI_DMACFG3	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0098)
#define ST40_EMPI_DSTATUS0	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0100)
#define ST40_EMPI_DSTATUS1	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0108)
#define ST40_EMPI_DSTATUS2	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0110)
#define ST40_EMPI_DSTATUS3	SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0118)
#define ST40_EMPI_RBAR0		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0200)
#define ST40_EMPI_RSR0		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0208)
#define ST40_EMPI_RLAR0		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0210)
#define ST40_EMPI_RBAR1		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0220)
#define ST40_EMPI_RSR1		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0228)
#define ST40_EMPI_RLAR1		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0230)
#define ST40_EMPI_RBAR2		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0240)
#define ST40_EMPI_RSR2		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0248)
#define ST40_EMPI_RLAR2		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0250)
#define ST40_EMPI_RBAR3		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0260)
#define ST40_EMPI_RSR3		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0268)
#define ST40_EMPI_RLAR3		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0270)
#define ST40_EMPI_RBAR4		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0280)
#define ST40_EMPI_RSR4		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0288)
#define ST40_EMPI_RLAR4		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x0290)
#define ST40_EMPI_RBAR5		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x02a0)
#define ST40_EMPI_RSR5		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x02a8)
#define ST40_EMPI_RLAR5		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x02b0)
#define ST40_EMPI_RBAR6		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x02c0)
#define ST40_EMPI_RSR6		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x02c8)
#define ST40_EMPI_RLAR6		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x02d0)
#define ST40_EMPI_RBAR7		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x02e0)
#define ST40_EMPI_RSR7		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x02e8)
#define ST40_EMPI_RLAR7		SH4_DWORD_REG(ST40_EMPI_REGS_BASE + 0x02f0)

/* MPX Arbiter control registers (all ST40 variants) */
#define ST40_MPXARB_VCR		SH4_DWORD_REG(ST40_MPXARB_REGS_BASE + 0x0000)
#define ST40_MPXARB_CONTROL	SH4_DWORD_REG(ST40_MPXARB_REGS_BASE + 0x0010)
#define ST40_MPXARB_DLLCONTROL	SH4_DWORD_REG(ST40_MPXARB_REGS_BASE + 0x4000)
#define ST40_MPXARB_DLLSTATUS	SH4_DWORD_REG(ST40_MPXARB_REGS_BASE + 0x4010)

/* Mailbox control registers (all ST40 variants) */
#define ST40_MAILBOX_ID_VER(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0000)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG1(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0004)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG2(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0008)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG3(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x000c)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG4(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0010)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG1_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0024)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG2_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0028)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG3_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x002c)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG4_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0030)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG1_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0044)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG2_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0048)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG3_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x004c)
#define ST40_MAILBOX_GROUP1_INTERRUPT_STATUS_REG4_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0050)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG1(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0064)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG2(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0068)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG3(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x006c)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG4(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0070)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG1_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0084)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG2_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0088)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG3_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x008c)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG4_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0090)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG1_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x00a4)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG2_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x00a8)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG3_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x00ac)
#define ST40_MAILBOX_GROUP1_INTERRUPT_ENABLE_REG4_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x00b0)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG1(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0104)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG2(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0108)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG3(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x010c)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG4(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0110)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG1_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0124)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG2_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0128)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG3_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x012c)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG4_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0130)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG1_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0144)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG2_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0148)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG3_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x014c)
#define ST40_MAILBOX_GROUP2_INTERRUPT_STATUS_REG4_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0150)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG1(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0164)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG2(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0168)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG3(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x016c)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG4(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0170)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG1_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0184)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG2_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0188)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG3_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x018c)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG4_SET(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0190)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG1_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x01a4)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG2_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x01a8)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG3_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x01ac)
#define ST40_MAILBOX_GROUP2_INTERRUPT_ENABLE_REG4_CLR(n)	SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x01b0)
#define ST40_MAILBOX_LOCK0(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0200)
#define ST40_MAILBOX_LOCK1(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0204)
#define ST40_MAILBOX_LOCK2(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0208)
#define ST40_MAILBOX_LOCK3(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x020c)
#define ST40_MAILBOX_LOCK4(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0210)
#define ST40_MAILBOX_LOCK5(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0214)
#define ST40_MAILBOX_LOCK6(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0218)
#define ST40_MAILBOX_LOCK7(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x021c)
#define ST40_MAILBOX_LOCK8(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0220)
#define ST40_MAILBOX_LOCK9(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0224)
#define ST40_MAILBOX_LOCK10(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0228)
#define ST40_MAILBOX_LOCK11(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x022c)
#define ST40_MAILBOX_LOCK12(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0230)
#define ST40_MAILBOX_LOCK13(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0234)
#define ST40_MAILBOX_LOCK14(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0238)
#define ST40_MAILBOX_LOCK15(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x023c)
#define ST40_MAILBOX_LOCK16(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0240)
#define ST40_MAILBOX_LOCK17(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0244)
#define ST40_MAILBOX_LOCK18(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0248)
#define ST40_MAILBOX_LOCK19(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x024c)
#define ST40_MAILBOX_LOCK20(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0250)
#define ST40_MAILBOX_LOCK21(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0254)
#define ST40_MAILBOX_LOCK22(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0258)
#define ST40_MAILBOX_LOCK23(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x025c)
#define ST40_MAILBOX_LOCK24(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0260)
#define ST40_MAILBOX_LOCK25(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0264)
#define ST40_MAILBOX_LOCK26(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0268)
#define ST40_MAILBOX_LOCK27(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x026c)
#define ST40_MAILBOX_LOCK28(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0270)
#define ST40_MAILBOX_LOCK29(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0274)
#define ST40_MAILBOX_LOCK30(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x0278)
#define ST40_MAILBOX_LOCK31(n)		SH4_DWORD_REG(ST40_MAILBOX##n##_REGS_BASE + 0x027c)

/* System configuration registers (all ST40 variants) */
#define ST40_SYSCONF_VCR		SH4_DWORD_REG(ST40_SYSCONF_REGS_BASE + 0x00)
#define ST40_SYSCONF_SYS_CON1_0		SH4_DWORD_REG(ST40_SYSCONF_REGS_BASE + 0x10)
#define ST40_SYSCONF_SYS_CON1_1		SH4_DWORD_REG(ST40_SYSCONF_REGS_BASE + 0x14)
#define ST40_SYSCONF_SYS_CON1		SH4_GWORD_REG(ST40_SYSCONF_REGS_BASE + 0x10)
#define ST40_SYSCONF_SYS_CON2_0		SH4_DWORD_REG(ST40_SYSCONF_REGS_BASE + 0x18)
#define ST40_SYSCONF_SYS_CON2_1		SH4_DWORD_REG(ST40_SYSCONF_REGS_BASE + 0x1c)
#define ST40_SYSCONF_SYS_CON2		SH4_GWORD_REG(ST40_SYSCONF_REGS_BASE + 0x18)
#define ST40_SYSCONF_CNV_STATUS		SH4_BYTE_REG(ST40_SYSCONF_REGS_BASE + 0x20)
#define ST40_SYSCONF_CNV_SET		SH4_BYTE_REG(ST40_SYSCONF_REGS_BASE + 0x28)
#define ST40_SYSCONF_CNV_CLEAR		SH4_BYTE_REG(ST40_SYSCONF_REGS_BASE + 0x30)
#define ST40_SYSCONF_CNV_CONTROL	SH4_DWORD_REG(ST40_SYSCONF_REGS_BASE + 0x38)
#define ST40_SYSCONF_SYS_STAT1_0	SH4_DWORD_REG(ST40_SYSCONF_REGS_BASE + 0x40)
#define ST40_SYSCONF_SYS_STAT1_1	SH4_DWORD_REG(ST40_SYSCONF_REGS_BASE + 0x44)
#define ST40_SYSCONF_SYS_STAT1		SH4_GWORD_REG(ST40_SYSCONF_REGS_BASE + 0x40)
#define ST40_SYSCONF_SYS_STAT2_0	SH4_DWORD_REG(ST40_SYSCONF_REGS_BASE + 0x48)
#define ST40_SYSCONF_SYS_STAT2_1	SH4_DWORD_REG(ST40_SYSCONF_REGS_BASE + 0x4c)
#define ST40_SYSCONF_SYS_STAT2		SH4_GWORD_REG(ST40_SYSCONF_REGS_BASE + 0x48)

/* Synchronous Serial Controller control registers (all ST40 variants) */
#define ST40_SSC_BRG(n)			SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0000)
#define ST40_SSC_TBUF(n)		SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0004)
#define ST40_SSC_RBUF(n)		SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0008)
#define ST40_SSC_CTL(n)			SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x000c)
#define ST40_SSC_IEN(n)			SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0010)
#define ST40_SSC_STA(n)			SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0014)
#define ST40_SSC_I2C(n)			SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0018)
#define ST40_SSC_SLAD(n)		SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x001c)
#define ST40_SSC_REP_START_HOLD(n)	SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0020)
#define ST40_SSC_START_HOLD(n)		SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0024)
#define ST40_SSC_REP_START_SETUP(n)	SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0028)
#define ST40_SSC_DATA_SETUP(n)		SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x002c)
#define ST40_SSC_STOP_SETUP(n)		SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0030)
#define ST40_SSC_BUS_FREE(n)		SH4_WORD_REG(ST40_SSC##n##_REGS_BASE + 0x0034)
#define ST40_SSC_CLR_STA(n)		SH4_DWORD_REG(ST40_SSC##n##_REGS_BASE + 0x0080)
#define ST40_SSC_AGFR(n)		SH4_DWORD_REG(ST40_SSC##n##_REGS_BASE + 0x0100)
#define ST40_SSC_PRSC(n)		SH4_DWORD_REG(ST40_SSC##n##_REGS_BASE + 0x0104)

/* Asynchronous Serial Controller control registers (all ST40 variants) */
#define ST40_ASC_BAUDRATE(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x00)
#define ST40_ASC_TXBUFFER(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x04)
#define ST40_ASC_RXBUFFER(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x08)
#define ST40_ASC_CONTROL(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x0c)
#define ST40_ASC_INTENABLE(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x10)
#define ST40_ASC_STATUS(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x14)
#define ST40_ASC_GUARDTIME(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x18)
#define ST40_ASC_TIMEOUT(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x1c)
#define ST40_ASC_TXRESET(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x20)
#define ST40_ASC_RXRESET(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x24)
#define ST40_ASC_RETRIES(n)		SH4_DWORD_REG(ST40_ASC##n##_REGS_BASE + 0x28)

#endif /* __ST40REG_H */
