/*---------------------------------------------------------------------------
* /drivers/stm/lpm.c
* Copyright (C) 2010 STMicroelectronics Limited
* Author:
* May be copied or modified under the terms of the GNU General Public
* License.  See linux/COPYING for more information.
*----------------------------------------------------------------------------
*/
#include <linux/stm/lpm.h>
#ifdef CONFIG_STM_LPM_RD_MONITOR
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/ioport.h>
#include <linux/bitops.h>
#include <linux/interrupt.h>
#include <linux/pm.h>
#include <linux/delay.h>
#include <linux/platform_device.h>
#include <linux/kthread.h>
#include <linux/hom.h>
#include <linux/stm/gpio.h>
#include <linux/stm/pms.h>
static wait_queue_head_t wait_queue;
static int wait_condition;

#define wake_gpio	stm_gpio(26, 7)

static irqreturn_t monitor_gpio_handler(int irq, void *ptr)
{
	wait_condition = 0;
	wake_up(&wait_queue);

	return IRQ_HANDLED;
}

static int monitor_gpio_monitor(void *params) {
	int gpio_val;

	pr_info("gpio_monitor thread started \n");

	while(1) {

	pr_info("gpio_monitor is going to wait\n");

	wait_condition = 1;
	wait_event_interruptible(wait_queue, wait_condition == 0);

	pr_info("gpio_monitor woken up\n");
	gpio_val = gpio_get_value(wake_gpio);

	pr_info("gpio value %d\n", gpio_val);

#if 1
	if(gpio_val ==0) {
		enum stlpm_wakeupdevices wakeupdevice;
		int NotUsed;
		pr_info("pin_val enter standby %d \n", gpio_val);

/*		stlpm_enterpassivestandby(); */
		pms_global_standby(PMS_GLOBAL_MEMHIBERNATION);

		stlpm_getwakeup_info(&wakeupdevice,&NotUsed,&NotUsed);
		pr_info("syetm woken up due to %d \n", wakeupdevice);
		}
#else

	if (!gpio_val) {
		hibernate_on_memory();
		}
#endif
	}

	return 0;
}

static ssize_t stlpm_show_powerkey(struct device *dev,
			struct device_attribute *attr, char *buf)
{
	int ret = 0;
	pr_info("\n power key pressed %s \n",wait_condition==0?"Yes":"No");
	ret = sprintf(buf, "%d \n", wait_condition);
	return ret;
}

static ssize_t stlpm_store_powerkey(struct device *dev,
			struct device_attribute *attr,
			const char *buf, size_t count)
{
	int value = 0;
	pr_info("\n");
	value =  simple_strtoul(buf, NULL, 4);
#warning "Please remove below line, after testing"
	/*stlpm_enterpassivestandby();*/
	pr_info(" application want to set power key to value = %d\n", value);
	return count;
}

static DEVICE_ATTR(powerkey, S_IRUGO | S_IWUSR, stlpm_show_powerkey,
			stlpm_store_powerkey);

 int __init stlpm_start_power_monitor(struct platform_device *pdev)
{
	int ret = -ENODEV;
	struct task_struct *th_monitor;

	ret = gpio_request(wake_gpio, "monitor_gpio");

	if (ret < 0) {
		pr_err("ERROR: Request pin Not done!\n");
		return ret;
		}

	init_waitqueue_head(&wait_queue);
	gpio_direction_input(wake_gpio);

	set_irq_type(gpio_to_irq(wake_gpio), IRQF_TRIGGER_FALLING);
	ret = request_irq(gpio_to_irq(wake_gpio), monitor_gpio_handler,
		IRQF_DISABLED, "monitor_irq", NULL);
	if (ret < 0) {
		pr_err("ERROR: Request irq Not done!\n");
		return ret;
	}
#if 1
	th_monitor = kthread_run(monitor_gpio_monitor, NULL, "gpio_monitor");
	if (!th_monitor) {
		pr_err("ERROR: Unable to start monitor thread");
		return -ENOMEM;
	}
#endif
	wait_condition = 1;
    ret=device_create_file(&(pdev->dev), &dev_attr_powerkey);
	return ret;
}

#endif 

/*#include <linux/stm/soc.h>*/
#include <linux/platform_device.h>
#include <linux/io.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/wait.h>
#include <linux/errno.h>
#include <linux/kthread.h>
#include <linux/semaphore.h>
#include <linux/i2c.h>
#include <linux/delay.h>
#include <linux/stm/platform.h>
#define MAX_MSG_DATA 6

/*Message commands */
#define STLPM_MSG_NOP           0x00
#define STLPM_MSG_VER           0x01
#define STLPM_MSG_ERR           0x82
#define STLPM_MSG_READ_RTC      0x03
#define STLPM_MSG_SET_TRIM      0x04
#define STLPM_MSG_ENTER_PASSIVE 0x5
#define STLPM_MSG_SET_WDT       0x6
#define STLPM_MSG_SET_RTC       0x7
#define STLPM_MSG_SET_FP        0x8
#define STLPM_MSG_SET_TIMER     0x9
#define STLPM_MSG_GET_STATUS    0xA
#define STLPM_MSG_GEN_RESET     0xB
#define STLPM_MSG_SET_WUD       0xC
#define STLPM_MSG_GET_WUD       0xD
#define STLPM_MSG_SET_IR        0x41
#define STLPM_MSG_GET_IRQ       0x42
#define STLPM_MSG_REPLY	        0x80

#define MAJORPROTO_VER      2
#define MINORPROTO_VER      0
#define MAJORSOFT_VER       1
#define MINORSOFT_VER       1
#define PATHSOFT_VER        0
#define BUILD_MONTH         11
#define BUILD_DAY           10
#define BUILD_YEAR          10
#warning "Please fill below m/c i2c number etc line numer 51"
#define ADDRESS_OF_EXT_MC 0x94
#define NUM_I2C_USED      2
#define MAILBOX_ADDRESS   0xFFFFEEEE
#define MAILBOX_SIZE      0x1000
#define MAILBOX_IRQ_NUM   0x3600

#ifdef CONFIG_STM_LPM_DEBUG
#define lpm_debug printk
#else
#define lpm_debug(fmt,arg...);
#endif

struct stlpm_message {
	unsigned char command_id;
	unsigned char transaction_id;
	unsigned char msg_data[MAX_MSG_DATA];
};

static struct stlpm_message  fw_reply_msg;
static struct stlpm_message  fw_request_msg[4];

struct stlpm_version FWVer;

struct stlpm_driver_data{
#ifdef CONFIG_CPU_SUBTYPE_STXORLY
unsigned int stlpm_mem_base;
#else
struct i2c_adapter         *I2C_Adapter;
#endif
unsigned char wakeupdevices;
struct task_struct *th;
};

struct stlpm_driver_data stlpm_drv;
/*static int tran_id = 0;*/

#define int_val 0x1 /*Interrupt generated*/

#define stat_int1  0x004
#define stat_int2  0x008
#define stat_int3  0x00C
#define stat_int4  0x010

#define stat_set1  0x024
#define stat_set2  0x028
#define stat_set3  0x02C
#define stat_set4  0x030
#define BYTE_MASK  0xFF

#define lpm_write32(base, offset, value)	iowrite32(value, (base + offset))
#define lpm_read32(base, offset)		ioread32(base + offset)


struct semaphore fw_reply_sem;
struct semaphore msg_protection_sem;
struct semaphore stlpm_task_sem;
static int stlpm_preparemsg(unsigned int command_id, unsigned char *msg, unsigned char msg_size, struct stlpm_message *response, unsigned int trans_id);
#ifdef CONFIG_CPU_SUBTYPE_STXORLY
static void ORLY_ISR(void *params)
{
        /*Read the data from mailbox memory*/
        unsigned int msg_read1, msg_read2;
        msg_read1 = lpm_read32(stlpm_drv.stlpm_mem_base, stat_int2);
        msg_read2 = lpm_read32(stlpm_drv.stlpm_mem_base, stat_int3);
        if(msg_read1 & STLPM_MSG_REPLY)
        {
                fw_reply_msg.command_id = msg_read1 & BYTE_MASK;
                fw_reply_msg.transaction_id = (msg_read1>>8) & BYTE_MASK;
                fw_reply_msg.msg_data[0] = (msg_read1>>16) & BYTE_MASK;
                fw_reply_msg.msg_data[1] = (msg_read1>>24) & BYTE_MASK;
                fw_reply_msg.msg_data[2] = msg_read2 & BYTE_MASK;
                fw_reply_msg.msg_data[3] = (msg_read2>>0x8) & BYTE_MASK;
                fw_reply_msg.msg_data[4] = (msg_read2>>16) & BYTE_MASK;
                fw_reply_msg.msg_data[5] = (msg_read2>>24) & BYTE_MASK;
                up(&fw_reply_sem);
        }
        else
        {
                /*Can we ask FW to send msg by msg*/
		 /* if not then handle message*/
                static int count=0;
		  int msgindex=count%4;
                 fw_request_msg[msgindex].command_id = msg_read1 & BYTE_MASK;
                 fw_request_msg[msgindex].transaction_id = msg_read1 >>8 & BYTE_MASK;
                 fw_request_msg[msgindex].msg_data[0] = (msg_read1>>16) & BYTE_MASK;
                 fw_request_msg[msgindex].msg_data[1] = (msg_read1>>24) & BYTE_MASK;
                 fw_request_msg[msgindex].msg_data[2] = msg_read2 & BYTE_MASK;
                 fw_request_msg[msgindex].msg_data[3] = (msg_read2>>0x8) & BYTE_MASK;
                 fw_request_msg[msgindex].msg_data[4] = (msg_read2>>16) & BYTE_MASK;
                 fw_request_msg[msgindex].msg_data[5] = (msg_read2>>24) & BYTE_MASK;
		  count++;
		  up(&stlpm_task_sem);
        }
        /*Clear mail box registersy*/
}
#endif
static int msg_request(void *params){
        /*Task Lock*/
	int i;
	unsigned char msg[5];
	while(1){
      	down_interruptible(&stlpm_task_sem);
	for(i=0;i<4;i++){
		if(fw_request_msg[i].command_id !=0){
				switch(fw_request_msg[i].command_id)
				{
					case STLPM_MSG_NOP:
					case STLPM_MSG_SET_TRIM:
					case STLPM_MSG_ENTER_PASSIVE:
					case STLPM_MSG_SET_WDT:
					case STLPM_MSG_SET_RTC:
					case STLPM_MSG_SET_FP:
					case STLPM_MSG_SET_TIMER:
					case STLPM_MSG_GET_STATUS:
					case STLPM_MSG_GEN_RESET:
					case STLPM_MSG_SET_WUD:
					case STLPM_MSG_GET_WUD:
					case STLPM_MSG_SET_IR:
					/* to be handled later on read RTC*/
					case STLPM_MSG_READ_RTC:
						msg[0]=fw_request_msg[i].command_id;
						msg[1]=EINVAL;
						stlpm_preparemsg(STLPM_MSG_ERR,msg,2,NULL,fw_request_msg[i].transaction_id);
						break;
					case STLPM_MSG_VER:
						msg[0]= MAJORPROTO_VER <<4| MINORPROTO_VER;
						msg[1]= MAJORSOFT_VER <<4 | MINORSOFT_VER;
						msg[2]= PATHSOFT_VER << 4 | BUILD_MONTH;
						msg[3]= BUILD_DAY;
						msg[4]= BUILD_YEAR;
						stlpm_preparemsg(STLPM_MSG_VER|STLPM_MSG_REPLY,msg,5,NULL,fw_request_msg[i].transaction_id);
						break;

				}
				fw_request_msg[i].command_id=0;
			}
	    }
	}
	return 0;
}

#ifdef CONFIG_CPU_SUBTYPE_STX7108
static int stlpm_recvrespone_i2c (struct stlpm_message *msg){
    struct i2c_msg i2c_mssg = {.addr = ADDRESS_OF_EXT_MC, /*Device address of slave*/
			                   .flags = I2C_M_RD,
                               .buf = (char *)&fw_reply_msg,
                               .len = 4};
    int err=0,i=0;
    lpm_debug("stlpm_recvrespone_i2c, size of msg 4 static address of ext device %d \n",i2c_mssg.addr);
    switch(msg->command_id)
    {
        case STLPM_MSG_NOP:
        case STLPM_MSG_SET_IR:
        case STLPM_MSG_GET_IRQ :
        case STLPM_MSG_SET_FP :
        case STLPM_MSG_ERR :
        case STLPM_MSG_SET_TRIM :
        case STLPM_MSG_ENTER_PASSIVE:
    	case STLPM_MSG_GEN_RESET:
        default:
        lpm_debug("stlpm_recvrespone_i2c, response not need \n");
        up(&fw_reply_sem);
        return 0;

        case STLPM_MSG_VER : i2c_mssg.len=7; break;
        case STLPM_MSG_READ_RTC :i2c_mssg.len=8; break;

        case STLPM_MSG_SET_TIMER :
        case STLPM_MSG_SET_WDT :
        case STLPM_MSG_SET_RTC :
        case STLPM_MSG_SET_WUD :i2c_mssg.len=2; break;

        case STLPM_MSG_GET_STATUS :
        case STLPM_MSG_GET_WUD :i2c_mssg.len=4; break;

    }
     err=i2c_transfer(stlpm_drv.I2C_Adapter, &i2c_mssg, 1);
     lpm_debug("i2c_transfer response error is %d \n",err);
     if(err>=0) {
     lpm_debug("stlpm_recvrespone_i2c command id %d \n",fw_reply_msg.command_id);
     lpm_debug("stlpm_recvrespone_i2c transid id %d \n",fw_reply_msg.transaction_id);
     for(i=0;i<i2c_mssg.len-2;i++) lpm_debug("%X ",fw_reply_msg.msg_data[i]);
        lpm_debug("\n"); }
     up(&fw_reply_sem);
     return err;

}
#endif
static int stlpm_sendmsg(struct stlpm_message *msg, unsigned char msg_size){
    	/* For ORLY only*/
        int err=0;
#ifdef CONFIG_CPU_SUBTYPE_STXORLY
    	lpm_write32(stlpm_drv.stlpm_mem_base,stat_set2,(msg.msg_data[1]<<24|msg.msg_data[0]<<16|msg.transaction_id<<8|msg.command_id));
     	if(msg_size>2 && msg_size <6)
    			 lpm_write32(stlpm_drv.stlpm_mem_base,stat_set3,(msg.msg_data[5]<<24|msg.msg_data[4]<<16|msg.msg_data[3]<<8|msg.msg_data[2]));
    	if(msg_size>6)
    		/*return error*/
    	/*generate mailbox interrupt*/
    	 lpm_write32(stlpm_drv.stlpm_mem_base,stat_set1,int_val);
#else
      struct i2c_msg i2c_mssg = {.addr = ADDRESS_OF_EXT_MC /*Device address of slave*/,
                                   .flags = 0,
                                   .buf = (char *) msg,
                                   .len = msg_size+2};
        lpm_debug("stlpm_sendmsg buf  %d and address is %d \n",*i2c_mssg.buf,i2c_mssg.addr);
        lpm_debug("stlpm_sendmsg, size of msg %d \n",msg_size+2);
        /*This is an re*/
        err=i2c_transfer(stlpm_drv.I2C_Adapter, &i2c_mssg, 1);
        lpm_debug("i2c_transfer send error is %d \n",err);
	    if(((msg->command_id & STLPM_MSG_REPLY)==0) && err >=0)
        {
            /*This is not a reply message so read the resonse of micro controller*/
             err=stlpm_recvrespone_i2c(msg);
        }
#endif
        return err;
}

static int gbltrans_id=0;
static int stlpm_preparemsg(unsigned int command_id, unsigned char *msg,
                            unsigned char msg_size, struct stlpm_message *response,
                            unsigned int trans_id)
{
    struct stlpm_message stlpm_msg;
    int count=0,err=0;
    lpm_debug("stlpm_preparemsg \n");
    down_interruptible(&msg_protection_sem);
    stlpm_msg.command_id=command_id;
    if(command_id&STLPM_MSG_REPLY) stlpm_msg.transaction_id = trans_id;
#warning "Please fill trxn id"
    else stlpm_msg.transaction_id = gbltrans_id++;

    for(count=0;count<msg_size;count++){
        stlpm_msg.msg_data[count]=*msg;
        msg++;
    }
    lpm_debug("Sending msg {%d, %d ",stlpm_msg.command_id,stlpm_msg.transaction_id);
    for(count=0;count<msg_size;count++){
    lpm_debug(" %d",stlpm_msg.msg_data[count]);}
    lpm_debug(" } \n");
    err=stlpm_sendmsg(&stlpm_msg,msg_size);

    if(((command_id&STLPM_MSG_REPLY)==0)&&err>=0) {err=0;
        /*wait for response here */
        down_interruptible(&fw_reply_sem);

        /*Just check reply message from FWLPM */
        if(stlpm_msg.transaction_id == fw_reply_msg.transaction_id){
            /*Copy the FW response*/
            response->command_id=fw_reply_msg.command_id;
            response->command_id=fw_reply_msg.transaction_id;
            for(count=0;count<MAX_MSG_DATA;count++) response->msg_data[count]=fw_reply_msg.msg_data[count];

            /* Check for error in FWLPM response*/
            if(fw_reply_msg.command_id==STLPM_MSG_ERR){
                /*just check error for command*/
                printk("Error respone \n");
                /* Get the actual error */
                err=fw_reply_msg.msg_data[1];
            }

        }
        else {
             //printk("Received response tran ID %d instead of %d \n",fw_reply_msg.transaction_id,stlpm_msg.transaction_id );
             err=-144; /* invalid trans id*/
        }
    }
    up(&msg_protection_sem);
    return err;
}

int stlpm_getversion(struct stlpm_version * DriverVersion, struct stlpm_version * FWVersion){
    int err = 0;
     char msg[4] = {0};
    struct stlpm_message response;
    if((DriverVersion == NULL)||(FWVersion == NULL))
        return -EINVAL;
    lpm_debug("added to test I2C again and again after probe \n");
    err=stlpm_preparemsg(STLPM_MSG_VER, msg, 0,&response,0);
    if(err==0){
    FWVersion->majorCommProtocol= response.msg_data[0]>>4;
    FWVersion->minorCommProtocol= response.msg_data[0]&0x0F;
    FWVersion->majorSoft = response.msg_data[1]>>4;
    FWVersion->minorSoft = response.msg_data[1]&0x0F;
    FWVersion->patchSoft = response.msg_data[2]>>4;
    FWVersion->month = response.msg_data[2]&0x0F;
    FWVersion->day = response.msg_data[3];
    FWVersion->year = response.msg_data[4];

    DriverVersion->majorCommProtocol=MAJORPROTO_VER;
    DriverVersion->minorCommProtocol=MINORPROTO_VER;
    DriverVersion->majorSoft = MAJORSOFT_VER;
    DriverVersion->minorSoft = MINORSOFT_VER;
    DriverVersion->patchSoft = PATHSOFT_VER;
    DriverVersion->month = BUILD_MONTH;
    DriverVersion->day = BUILD_DAY;
    DriverVersion->year = BUILD_YEAR;}
    return err;
}

EXPORT_SYMBOL(stlpm_getversion);

int stlpm_configure_wdt(int timeInMs){
    char msg[4];
    struct stlpm_message response;
    if(!timeInMs)
        return EINVAL;
    msg[0] = timeInMs & BYTE_MASK;
    msg[1] = (timeInMs>>8) & BYTE_MASK;
    msg[2] = (timeInMs>>16) & BYTE_MASK;
    msg[3] = (timeInMs>>24) & BYTE_MASK;
    return(stlpm_preparemsg(STLPM_MSG_SET_WDT, msg, 4,&response,0));
}
EXPORT_SYMBOL(stlpm_configure_wdt);
int stlpm_getFWState(enum stlpm_lpmstate *FWState){
    char msg[4]={0};
    int err=0;
    struct stlpm_message reply_msg;
    if(FWState==NULL)
        return EINVAL;
    err=stlpm_preparemsg(STLPM_MSG_GET_STATUS,msg,0,&reply_msg,0);
    if(err==0){
   	*FWState = reply_msg.msg_data[0];
   }
    return err;
}
EXPORT_SYMBOL(stlpm_getFWState);
int stlpm_reset(void){
    int err = 0;
    char msg[4]={0};
    struct stlpm_message response;
    err=stlpm_preparemsg(STLPM_MSG_GEN_RESET,msg,0,&response,0);
    return err;
}
EXPORT_SYMBOL(stlpm_reset);
int stlpm_sbcstandby (char SBCStandby){
        /*Need to set SBC mode directly to the memory location
        no message is used for this.*/
return 0;
}

int stlpm_setwakeup_device(enum stlpm_wakeupdevices deviceId, union stlpm_wakeupdata devicedata){
    int err = 0;
    char msg[4] = {0};
    struct stlpm_message response;
    if(deviceId & stlpm_drv.wakeupdevices)
    return err; /*Device is already set as wakeup device */
    if(deviceId&STLPM_WAKEUP_RTC){
        /*configure time*/
        msg[3] = devicedata.wakeuptime.secs;
        msg[2] = devicedata.wakeuptime.mins;
        msg[1] = (devicedata.wakeuptime.hours&0xff);
        msg[0] = (devicedata.wakeuptime.hours>>8&0xFF);
        err=stlpm_preparemsg(STLPM_MSG_SET_TIMER, msg, 4,&response,0);
    }
    else {
        stlpm_drv.wakeupdevices |= deviceId;
    }
    msg[0] = stlpm_drv.wakeupdevices | deviceId;
    err = stlpm_preparemsg(STLPM_MSG_SET_WUD, msg, 1,&response,0);
    return err;
}
EXPORT_SYMBOL(stlpm_setwakeup_device);
int stlpm_setRTC(struct stlpm_time *newRTC){
    int err = 0;
    char msg[4] = {0};
    struct stlpm_message response;

    msg[3] = newRTC->secs;
    msg[2] = newRTC->mins;
    msg[1] = newRTC->hours&0xff;
    msg[0] = newRTC->hours>>8&0xFF;
    err=stlpm_preparemsg(STLPM_MSG_SET_RTC, msg, 4,&response,0);
    return err;
}
EXPORT_SYMBOL(stlpm_setRTC);
static int stlpm_enterpassivestandby(void){
    int err = 0;
    char msg[4] = {0};
    struct stlpm_message response;
    err=stlpm_preparemsg(STLPM_MSG_ENTER_PASSIVE, msg, 0,&response,0);
    return err;
}
// EXPORT_SYMBOL(stlpm_enterpassivestandby);
int stlpm_exitpassivestandby(void){
 return 0;
}

int stlpm_getwakeup_info(enum stlpm_wakeupdevices *wakeupdevice, int *validsize, int *data){
    char msg[4]={0};
    int err=0;
    struct stlpm_message response;
    if(wakeupdevice==NULL || validsize==NULL || data==NULL)
    return EINVAL;
    err=stlpm_preparemsg(STLPM_MSG_GET_WUD,msg,0,&response,0);
    if(err==0) {
	 *wakeupdevice=response.msg_data[0];
    }

    return err;
}
EXPORT_SYMBOL(stlpm_getwakeup_info);
#ifdef CONFIG_STM_LPM_RD_MONITOR
extern int stlpm_start_power_monitor(struct platform_device *pdev);
#endif 
static int __init stlpm_probe(struct platform_device *pdev)
{
    char msg[4] = {0};
 	struct stlpm_message response;
 	int err;
 	lpm_debug("stlpm probe \n");
#ifdef CONFIG_CPU_SUBTYPE_STXORLY
        struct resource *res;
    	res = platform_get_resource(pdev, IORESOURCE_MEM, 0);
    	if (!res)
    		return -ENODEV;

    	if (!devm_request_mem_region(&pdev->dev, res->start,
    		res->end - res->start, "stlpm")){
    		printk(KERN_ERR "%s: Request mem 0x%x region not done\n",
    			__func__, res->start);
    		return -ENOMEM;
    	}

    	if (!(stlpm_drv.stlpm_mem_base =
    		devm_ioremap_nocache(&pdev->dev, res->start,
    				(int)(res->end - res->start)))) {
    		printk(KERN_ERR "%s: Request iomem 0x%x region not done\n",
    			__func__, (unsigned int)res->start);
    		return -ENOMEM;
    	}

    	/*irq request */
        if(!(res=platform_get_resource(pdev, IORESOURCE_IRQ, 0))){
                printk(KERN_ERR "%s Request irq %d not done\n",__FUNCTION__,res->start);
                return -ENODEV;
        }
        if(devm_request_irq(&pdev->dev, res->start, ORLY_ISR,
                IRQF_DISABLED, "ORLY", pdev)<0){
                printk(KERN_ERR "%s: Request orly irq not done\n",__FUNCTION__);
                return -ENODEV;
        }
#else

    stlpm_drv.I2C_Adapter=i2c_get_adapter(NUM_I2C_USED);
    if(stlpm_drv.I2C_Adapter==NULL) {
                printk(KERN_ERR "%s: Request i2c  7108 not done adapter %d not found \n",__FUNCTION__,(int) NUM_I2C_USED);
                return -ENODEV;
     }
    lpm_debug("stlpm i2c adapter found at %d i2c is %x \n",NUM_I2C_USED,(unsigned int)stlpm_drv.I2C_Adapter);
#endif

        /*Semaphore initialization*/
        sema_init(&fw_reply_sem, 0);
        sema_init(&msg_protection_sem, 1);
        sema_init(&stlpm_task_sem,0);

        stlpm_drv.th = kthread_create(msg_request, NULL, "lpm_read_task");
        if(IS_ERR(stlpm_drv.th)){
                printk(KERN_ERR "Unable to start thread");
		  return -ENOMEM;
        	}
#ifdef CONFIG_STM_LPM_RD_MONITOR
        err=stlpm_start_power_monitor(pdev);
#endif

        /*Store Firmware Version*/
        err=stlpm_preparemsg(STLPM_MSG_VER, msg, 0,&response,0);
        if(err==0) {
        FWVer.majorCommProtocol = response.msg_data[0] >> 4& 0xF0;
        FWVer.minorCommProtocol = response.msg_data[0] & 0x0F;
        FWVer.majorSoft = response.msg_data[1] >> 4& 0xF0;
        FWVer.minorSoft = response.msg_data[1] & 0x0F;
        FWVer.patchSoft = response.msg_data[2] >> 4& 0xF0;
        FWVer.month = response.msg_data[2] & 0x0F;
        FWVer.day = response.msg_data[3] ;
        FWVer.year =response.msg_data[4] ; }
        return err;

}

static int stlpm_remove(struct platform_device *pdev)
{
    lpm_debug("stlpm_remove \n");
#ifdef CONFIG_CPU_SUBTYPE_STXORLY
    	struct resource *res;
    	res = platform_get_resource(pdev, IORESOURCE_IRQ, 0);
    	devm_free_irq(&pdev->dev, res->start, NULL);
    	devm_iounmap(&pdev->dev, (void *)stlpm_drv.stlpm_mem_base);
#else
    	i2c_put_adapter(stlpm_drv.I2C_Adapter);
#endif
    	return 0;
}

static int stlpm_freeze(struct device *dev)
{
    lpm_debug("stlpm_suspend state \n");
	stlpm_enterpassivestandby();
   	return 0;
}

static int stlpm_restore(struct device *dev)
{
    lpm_debug("stlpm_resume \n");
   	return 0;
}
static struct dev_pm_ops stm_lpm_pm_ops = {
	.freeze = stlpm_freeze,  /* on standby/memstandby */
	.restore = stlpm_restore,
};
static struct platform_driver stlpm_driver = {
        .driver.name = "stlpm",
        .driver.owner  = THIS_MODULE,
 	.driver.pm     = &stm_lpm_pm_ops, 
        .probe = stlpm_probe,
    	.remove = stlpm_remove,

//    	.suspend = stlpm_suspend,
  //  	.resume = stlpm_resume,

};

static struct platform_device stlpm_device = {
        .name = "stlpm",
        .id = 0,
#ifdef CONFIG_CPU_SUBTYPE_STXORLY
        .num_resources = 2,
        .resource = (struct resource[]){

                {   .start = MAILBOX_ADDRESS,
	                .end   = MAILBOX_ADDRESS+ MAILBOX_SIZE,
	                .flags = IORESOURCE_MEM,
                },

                {   .start = evt2irq(MAILBOX_IRQ_NUM),/*mailbox interrupt*/
	                .end   = evt2irq(MAILBOX_IRQ_NUM),
	                .flags = IORESOURCE_IRQ
	            }
        }
#endif

};

static int __init stlpm_init(void){
        int err=0;
        err=platform_driver_register(&stlpm_driver);
        err=platform_device_register(&stlpm_device);
        printk("stlpm err %d \n", err);
    	printk("STLPM driver registered\n");
    	return err;
}

void __exit stlpm_exit(void){
	printk("STLPM driver removed \n");
        platform_driver_unregister(&stlpm_driver);
        platform_device_unregister(&stlpm_device);
}


module_init(stlpm_init);
module_exit(stlpm_exit);

MODULE_AUTHOR("STMicroelectronics  <www.st.com>");
MODULE_DESCRIPTION("lpm device driver for STMicroelectronics devices");
MODULE_LICENSE("GPL");


