/*
 * Copyright (C) 2010 ARM Limited. All rights reserved.
 * 
 * This program is free software and is provided to you under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation, and any use by you of this program is subject to the terms of such GNU licence.
 * 
 * A copy of the licence is included with the program, and can also be obtained from Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

/**
 * @file mali_osk_misc.c
 * Implementation of the OS abstraction layer for the kernel device driver
 */
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <asm/cacheflush.h>
#include "mali_osk.h"

void _mali_osk_dbgmsg( const char *fmt, ... )
{
    va_list args;
    va_start(args, fmt);
    vprintk(fmt, args);
	va_end(args);
}

void _mali_osk_abort(void)
{
	/* make a simple fault by dereferencing a NULL pointer */
	*(int *)0 = 0;
}

void _mali_osk_break(void)
{
	_mali_osk_abort();
}
