/*
 * Copyright (C) 2010 STMicroelectronics Ltd
 * Author(s): Filippo Arcidiacono <filippo.arcidiacono@st.com>
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 *
 */

#ifndef _SOCKETCALLS_H
#define _SOCKETCALLS_H

/*
 * WRAPPER function is defined as __wrapper_<name> in case of
 * __UCLIBC_HAS_SOCKETCALLS_COMPATIBILITY__ is on; in this case it tries to call
 * the __sys_<name> implemented by means of syscalls, and if the running kernel
 * doesn't support it (errno is ENOSYS), then it calls __compat_<name>
 * implemented by means of the socketcall multiplexer.
 */

#ifdef __UCLIBC_HAS_SOCKETCALLS_COMPATIBILITY__
#define GEN_WRAPPER2(type,name,type1,arg1,type2,arg2)\
	type __wrapper_##name(type1 arg1, type2 arg2)\
{\
	int res;\
\
	res = __sys_##name(arg1, arg2);\
	if ((res < 0) && (errno == ENOSYS))\
		return __compat_##name(arg1, arg2);\
\
	return res;\
}

#define GEN_WRAPPER3(type,name,type1,arg1,type2,arg2,type3,arg3)\
	type __wrapper_##name(type1 arg1, type2 arg2, type3 arg3)\
{\
	int res;\
\
	res = __sys_##name(arg1, arg2, arg3);\
	if ((res < 0) && (errno == ENOSYS))\
		return __compat_##name(arg1, arg2, arg3);\
\
	return res;\
}

#define GEN_WRAPPER4(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4)\
	type __wrapper_##name(type1 arg1, type2 arg2, type3 arg3, type4 arg4)\
{\
	int res;\
\
	res = __sys_##name(arg1, arg2, arg3, arg4);\
	if ((res < 0) && (errno == ENOSYS))\
		return __compat_##name(arg1, arg2, arg3, arg4);\
\
	return res;\
}

#define GEN_WRAPPER5(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4,\
					type5,arg5)\
	type __wrapper_##name(type1 arg1, type2 arg2, type3 arg3, type4 arg4,\
					type5 arg5)\
{\
	int res;\
\
	res = __sys_##name(arg1, arg2, arg3, arg4, arg5);\
	if ((res < 0) && (errno == ENOSYS))\
		return __compat_##name(arg1, arg2, arg3, arg4, arg5);\
\
	return res;\
}

#define GEN_WRAPPER6(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4,\
					type5,arg5,type6,arg6)\
	type __wrapper_##name(type1 arg1, type2 arg2, type3 arg3, type4 arg4,\
					type5 arg5, type6 arg6)\
{\
	int res;\
\
	res = __sys_##name(arg1, arg2, arg3, arg4, arg5, arg6);\
	if ((res < 0) && (errno == ENOSYS))\
		return __compat_##name(arg1, arg2, arg3, arg4, arg5, arg6);\
\
	return res;\
}

/*
 * SOCKET_FUNCTION is defined as __wrapper_<name> function when
 * __UCLIBC_HAS_SOCKETCALLS_COMPATIBILITY__ is on
 */
#define SOCKET_FUNCTION(__name, args...) __wrapper_##__name(args)
#define GEN_ALIAS(__name) weak_alias(__wrapper_##__name,__name)
#else
#define GEN_WRAPPER2(type,name,type1,arg1,type2,arg2)
#define GEN_WRAPPER3(type,name,type1,arg1,type2,arg2,type3,arg3)
#define GEN_WRAPPER4(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4)
#define GEN_WRAPPER5(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4,\
					type5,arg5)
#define GEN_WRAPPER6(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4,\
					type5,arg5,type6,arg6)

/*
 * SOCKET_FUNCTION is defined as __sys_<name> function when
 * __UCLIBC_HAS_SOCKETCALLS_COMPATIBILITY__ is off
 */
#define SOCKET_FUNCTION(__name, args...) __sys_##__name(args)
#define GEN_ALIAS(__name) weak_alias(__sys_##__name,__name)
#endif

#endif
