/* vi: set sw=4 ts=4: */
/*
 * setresgid() for uClibc
 *
 * Copyright (C) 2000-2006 Erik Andersen <andersen@uclibc.org>
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 */

#include <sys/syscall.h>
#ifdef __USE_GNU
#include <unistd.h>
#include <setxid.h>

#if defined __NR_setresgid || defined __NR_setresgid32
int setresgid(gid_t rgid, gid_t egid, gid_t sgid)
{
	int result;
#if defined(__NR_setresgid32)
# undef __NR_setresgid
# define __NR_setresgid __NR_setresgid32

#elif defined(__NR_setresgid)

	if (((rgid + 1) > (gid_t) ((__kernel_gid_t) - 1U))
		|| ((egid + 1) > (gid_t) ((__kernel_gid_t) - 1U))
		|| ((sgid + 1) > (gid_t) ((__kernel_gid_t) - 1U))) {
		__set_errno(EINVAL);
		return -1;
	}
#endif
	result = INLINE_SETXID_SYSCALL (setresgid, 3, rgid, egid, sgid);
	return result;
}

libc_hidden_def(setresgid)
#endif

#endif
