/* vi: set sw=4 ts=4: */
/*
 * setreuid() for uClibc
 *
 * Copyright (C) 2000-2006 Erik Andersen <andersen@uclibc.org>
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 */

#include <sys/syscall.h>
#include <unistd.h>
#include <bits/wordsize.h>
#include <setxid.h>

int setreuid(uid_t ruid, uid_t euid)
{
	int result;
#if (__WORDSIZE == 32 && defined(__NR_setreuid32)) || __WORDSIZE == 64
# ifdef __NR_setreuid32
#  undef __NR_setreuid
#  define __NR_setreuid __NR_setreuid32
# endif

#else

	if (((ruid + 1) > (uid_t) ((__kernel_uid_t) - 1U))
		|| ((euid + 1) > (uid_t) ((__kernel_uid_t) - 1U))) {
		__set_errno(EINVAL);
		return -1;
	}
#endif
	result = INLINE_SETXID_SYSCALL (setreuid, 2, ruid, euid);
	return result;
}

libc_hidden_def(setreuid)
